;+
; Project     : SOHO - CDS
;
; Name        : 
;	GET_DFONT()
; Purpose     : 
;       return a widget font whose size is compatible with current device
; Explanation : 
;	Useful for selecting fonts to fit into  widgets
; Use         : 
;	Result = GET_DFONT(UFONT)
; Inputs      : 
;       UFONT = user's optional input fonts (string array)
; Opt. Inputs : 
;	None.
; Outputs     :
;            DFONT = returned fonts (string array)
; Opt. Outputs: 
;	None.
; Keywords    : 
;       None.
; Calls       : 
;	DEVICE
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;	None.
; Category    : 
;	Online_help.
; Prev. Hist. : 
;       Written Elaine Einfalt (HSTX) May 1992.
; Modified    : 
;       Version 1, Dominic Zarro, GSFC, 1 August 1994.
;               Corrected some bugs
; Version     : 
;	Version 1, 1 August 1994.
;-
  
function get_dfont,ufont

on_error,1

;
; If no window currently exists then create a window,
; or else the DEVICE,FONT command will create one, but won't delete it later.
;

if !d.window eq -1 then begin                   ; if no windows are existing
 window,/free, xsize=1, ysize=1, /pixmap        ; make window
 temp_window = !d.window                        ; remember window
endif

if datatype(ufont) ne 'STR' then begin
 ufont = ["*menu*-r-*--12-*", 		$
          "*menu*-r-*--13-*", 			$
	        "*helvetica*bold*-r-*--12-*", 	$ 
	        "*time*-r-*--12-*"]
endif

floop 	 = n_elements(ufont)			; number of different searches
got_one = 0
counter = 0

;
; Search the hardware fonts for a font that matches the user's input.
;

while (counter lt floop) and not(got_one) do begin
   ;
   ; 1) see if any system hardware fonts fit the font designation.
   ; 2) return those matches in string or string array DEFNAMES,
   ; 3) and, the number of matches are returned in in DEF_NUM.
   ;

 device, font=ufont(counter), get_fontname=defnames, get_fontnum=def_num

 if def_num gt 0 then got_one = 1 	; there is at least one font match
 counter = counter + 1
endwhile

if (n_elements(temp_window) ne 0) then wdelete, temp_window 	; kill temp

if def_num ne 0 then dfont=defnames else dfont=''
                   
;if dfont(0) eq '' then message,'font unavailable',/info
if n_elements(dfont) eq 1 then dfont=dfont(0)
return,dfont
end


