PRO popup_msg_event, event
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; pro popup_msg_event, event
;
; The event handler for PRO POP_MSG
;  calls to  :  none
;  common    :  none
;
;  The only purpose of the routine is to kill the message window, 
;     created by PRO POP_MSG, AFTER the user reads the message.
;     The user clicks the "Dismiss" button to get here.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
   WIDGET_CONTROL, event.top, /destroy ; This widget is modaled so its the 
                                ;  only widget the user is able to kill 
   RETURN 
END

;===========================================================================

PRO popup_msg, text, title=title, group=group, modal=modal, font=font, $
                     multiple=multiple, left_justify=left_justify
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:
;       POPUP_MSG
;
; PURPOSE:
;       Display a message from a popup text widget.
;
; Explanation:
;     This routine creates a message window that informs the user with a
;     message and requires the user to read the message and to dismiss the
;     window before control will return to the calling procedure.
;
; Calling sequence:
;     popup_msg, message [, title=title, group=group, font=font,$
;                           multiple=multiple]
;
;  calls to  :  xregistered('pop_msg'), xmanager,'popup_msg'
;
;  common    :  none
;
; INPUT
;     message:  string or string vector containing a message
;		that will be displayed on the screen for the 
;		user to read.
;		(multi-line messages are aesthetically better)
;
; Optional inputs:
;     title:    Optional title of the message window
;     group:    ID number of the widget which acts as a group leader
;     modal:    Make the calling widget inactive if set
;    
; OUTPUT
;     none
;
; MODIFICATION HISTORY
;	JAN 1993        -- Elaine Einfalt (HSTX)
;       August 19, 1994 -- Liyun Wang (ARC)
;       August 31, 1994 -- Liyun Wang (ARC), added GROUP keyword
;       Feb 16 1995     -- C D Pike, RAL.  Added FONT and MULTIPLE keywords.
;       Feb 20 1995     -- Added crude left justify option.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;-
;
;  Allow multiple copies if explicitly requested.
;
   IF NOT KEYWORD_SET(multiple) THEN BEGIN
      IF xregistered('popup_msg') THEN RETURN 
   ENDIF

;
;  Allow user font specification
;
   IF NOT KEYWORD_SET(font) THEN font = ''
   
   IF (N_ELEMENTS(title) EQ 0) THEN title = 'Message'
   IF N_ELEMENTS(text) EQ 0 THEN BEGIN
      text = ['Usage:','    popup_msg, text [,title=title]']
      title = 'POPUP_MSG'
   ENDIF 
   
   button_name = ' Dismiss '   ; word appearing in button

   mess_siz = N_ELEMENTS(text) - 1 ; lines in message, -1 for loop
   IF mess_siz LT 0 THEN BEGIN  ; no user provided message
      mess_siz = N_ELEMENTS(text) - 1 ; # times to loop below
      RETURN
   ENDIF

   base = WIDGET_BASE(title=title, /column, space=20, xpad=10, ypad = 10)
   
   tmp_bs = WIDGET_BASE(base, /column, xpad = 50)
   respond = WIDGET_BUTTON(tmp_bs, value= button_name, /frame)
   
   text_part = WIDGET_BASE(base, /column) ; write message 

;
;  left justified or centred?
;
   if keyword_set(left_justify) then begin
      xlen = max(strlen(text))
      info = widget_text(text_part,ysize=n_elements(text)+2,xsize=xlen,font=font)
      widget_control,info,set_val=text
   endif else begin
      for i = 0, mess_siz DO begin
         info = WIDGET_LABEL(text_part, value=text(i),font=font)
      endfor
   endelse

   WIDGET_CONTROL, base, /realize ; Realize the widget
   XMANAGER,'popup_msg', base, group = group, modal = KEYWORD_SET(modal)

   RETURN 
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of 'popup_msg.pro'.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
