;+
; Project     :	SOHO/CDS
;
; Name        : XACK
;
; Purpose     : Make user acknowledge an action
;
; Use         : xack
;
; Inputs      : 
;
; Opt. Inputs : ARRAY = message to user
;
; Outputs     : None.
;
; Keywords    : 
;               GROUP = widget ID of calling widget.
;               MODAL = set to make calling widget insensitive.
;               SPACE = lines of border space surrounding message text.
;               XOFF,YOFF = pixel (X,Y) offsets relative to calling widget.
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Help
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 12 October 1994
;
; Version     : 1
;-

pro xack_event,  event                         ;event driver routine

common xack,xack_base

if n_elements(xack_base) eq 0 then xack_base=event.top
on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)

 case bname of 

  'close'   : begin 
   xkill,event.top
   delvarx,xack_base
  end

  else:  return
 endcase
endif
return & end

;--------------------------------------------------------------------------- 

pro xack,array,group=group,xoff=xoff,yoff=yoff,modal=modal,space=space,font=font

on_error,1

if not have_widgets() then message,'widgets unavailable'

;-- make widgets

wfont=''
if datatype(font) eq 'STR' then wfont=(get_dfont(font))(0)

get_screen,fspace,fxpad,fypad

wbase=widget_base(title=' ',/column,space=fspace,xpad=fxpad,ypad=fypad)

if datatype(array) eq 'STR' then begin
 row1=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
 if n_elements(space) eq 0 then begin
  sy=(n_elements(array) < 5)
  blank=replicate('',(sy/2 > 3))
 endif else begin
  if space gt 0 then blank=replicate('',space)
 endelse
 if n_elements(blank) gt 0 then sarr=[blank,array,blank] else sarr=array
 ysize=n_elements(sarr)
 wtext=widget_text(row1,xsize=max(strlen(array)),ysize=ysize,value=sarr,font=wfont)
endif
 
row2=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)

temp=widget_base(row2,/row,space=10*fspace,xpad=10*fxpad,ypad=10*fypad)

ackb=widget_button(temp,value='Acknowledge',uvalue='close',/no_release,font=wfont,/frame)


if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 if n_elements(group) ne 0 then begin
  widget_control,wbase,/realize,tlb_get_size=wsize,map=0,show=0
  widget_control,group,tlb_get_offset=goff,tlb_get_size=gsize
  xsize=((gsize(0)-wsize(0))/2) > 0.
  ysize=((gsize(1)-wsize(1))/2) > 0.
  xoff=(goff(0)+xsize)
  yoff=(goff(1)+ysize)
 endif
endif

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,/realize,/map else $
  widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map

widget_control,wbase,/show  
xmanager,'xack',wbase,group=group,just_reg=just_reg,modal=modal
if (not keyword_set(group)) and (not keyword_set(just_reg)) then xmanager
 
return & end

