;---------------------------------------------------------------------------
; Document name: xanswer.pro
; Created by:    Liyun Wang, GSFC/ARC, March 8, 1995
;
; Last Modified: Wed Mar 29 13:25:12 1995 (lwang@achilles.nascom.nasa.gov)
;---------------------------------------------------------------------------
;
;+
; PROJECT:
;       SOHO - CDS/SUMER
;
; NAME:	
;       XANSWER()
;
; PURPOSE:
;       Popup widget to get a Yes/No answer for a given question
;
; EXPLANATION:
;       
; CALLING SEQUENCE: 
;       Result = xanswer(question [,/str])
;
; INPUTS:
;       QUESTION - A string scalar or vector for the question presented to the
;                  user 
;
; OPTIONAL INPUTS: 
;       FLASH - Make the question flash for number of FLASH times
;       RATE  - Flashing rate in seconds; default: 0.25 sec.
;
; OUTPUTS:
;       RESULT - A numerical value of 1 or 0, or a string scalar with a value
;                'Y' or 'N' if the keyword STR is set 
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS:
;       STR   - Set this keyword to make string type return
;       BEEP  - Make a beep if set
;
; CALLS:
;       DATATYPE, BELL
;
; COMMON BLOCKS:
;       XANSWER - Internal common block used the program
;
; RESTRICTIONS: 
;       None.
;
; SIDE EFFECTS:
;       All events are trapped and all other widgets are desensitized until an
;       option is chosen. (The keyword MODAL is used with xmanager)
;
; CATEGORY:
;       
; PREVIOUS HISTORY:
;       Written March 8, 1995, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       Version 1, created, Liyun Wang, GSFC/ARC, March 8, 1995
;
; VERSION:
;       Version 1, March 8, 1995
;-
;
PRO xanswer_event, event
   COMMON for_xanswer, answer
   WIDGET_CONTROL, event.top, get_uvalue = ans
   WIDGET_CONTROL, event.id, get_uvalue = opt
   CASE (opt) OF
      'yes': BEGIN
         answer = 1
         WIDGET_CONTROL, event.top, /destroy
      END
      'no': BEGIN
         answer = 0
         WIDGET_CONTROL, event.top, /destroy
      END
      ELSE:
   ENDCASE
END

FUNCTION xanswer, question, str=str, flash=flash, beep=beep, rate=rate
   COMMON for_xanswer, answer
   ON_ERROR, 2
   IF datatype(question) NE 'STR' THEN BEGIN
      question = 'Do you wish to continue?'
   ENDIF
   IF N_ELEMENTS(rate) EQ 0 THEN rate = 0.25

   wfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
   wfont=(get_dfont(wfont))(0)

   base = WIDGET_BASE(title = 'XANSWER', /column, /frame)
   base1 = WIDGET_BASE(base, /column, /frame)
   num = N_ELEMENTS(question)
   text = LONARR(num)
   FOR i = 0, num-1 DO text(i) = WIDGET_LABEL(base1,value = question(i),$
                                             font = '9x15bold')
   xmenu, ['Yes','No'], base1, /frame, /exclusive, /no_release, /row, $
      uvalue = ['yes','no'], font = wfont
   WIDGET_CONTROL, base, /realize
   IF KEYWORD_SET(beep) THEN bell
   IF N_ELEMENTS(flash) NE 0 AND datatype(flash) EQ 'INT' THEN BEGIN
      FOR i = 0, flash-1 DO BEGIN
         FOR j = 0, num-1 DO WIDGET_CONTROL, text(j), set_value = ''
         WAIT, rate
         FOR j = 0, num-1 DO WIDGET_CONTROL, text(j), set_value = question(j)
         WAIT, rate
      ENDFOR
   ENDIF
   XMANAGER, 'xanswer', base, /modal
   IF KEYWORD_SET(str) THEN BEGIN
      IF answer THEN RETURN, 'Y' ELSE RETURN, 'N'
   ENDIF ELSE BEGIN
      IF answer THEN RETURN, 1 ELSE RETURN, 0
   ENDELSE
END

;---------------------------------------------------------------------------
; End of 'xanswer.pro'.
;---------------------------------------------------------------------------
