;+
; Project     :	SOHO - CDS
;
; Name        : XINPUT
;
; Purpose:    : allow user to enter text
;
; Use         : xinput,text
;
; Inputs      : None.
;
; Opt. Inputs : INSTRUCT = instructions for user
;
; Outputs     : TEXT = string response text entered by user
;
; Opt. Outputs: None.
;
; Keywords    : 
;              GROUP = group leader of caller
;              MODAL = modal (make caller insensitive)
;              XOFF,YOFF = device (x,y) offsets of XINPUT base relative to caller
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Help
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 23 October 1994
;
;-


pro xinput_event,  event                         ;event driver routine

common xinput,xtext
on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)
 if bname eq 'CANCEL' then delvarx,xtext
 widget_control,event.top,/destroy,/clear_events,bad_id=destroyed
endif

;-- text widgets

if wtype eq 3 then begin
 widget_control,event.id,get_value=xtext
endif

return & end

;--------------------------------------------------------------------------- 

pro xinput,text,instruct,group=group,$
 xoff=xoff,yoff=yoff,modal=modal,handler=handler

common xinput,xtext
on_error,1

if not have_widgets() then message,'widgets unavailable'

;-- make widgets

wfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
wfont=(get_dfont(wfont))(0)
get_screen,fspace,fxpad,fypad

wbase=widget_base(title='  ',/column,space=fspace,xpad=fxpad,ypad=fypad)

if datatype(instruct) eq 'STR' then begin
 comment=instruct
 comment=[' ',comment,' ']
 xsize=max(strlen(comment))
 ysize=n_elements(comment)
 row1=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
 wtext=widget_text(row1,xsize=xsize,ysize=ysize,value=comment,font=wfont)
endif

row2=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
wtext=widget_text(row2,xsize=30,ysize=1,/editable,/all,font=wfont)

row3=widget_base(wbase,/row,space=20*fspace,xpad=fxpad,ypad=fypad)
temp1=widget_base(row3,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
quit=widget_button(temp1,value='CANCEL',uvalue='CANCEL',font=wfont)
temp2=widget_base(row3,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
ok=widget_button(temp2,value='ACCEPT',uvalue='ACCEPT',font=wfont)

;-- realize and position

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 if n_elements(group) ne 0 then begin
  widget_control,wbase,/realize,tlb_get_size=wsize,map=0
  widget_control,group,tlb_get_offset=goff,tlb_get_size=gsize
  xsize=((gsize(0)-wsize(0))/2) > 0.
  ysize=((gsize(1)-wsize(1))/2) > 0.
  xoff=goff(0)+xsize
  yoff=goff(1)+ysize
 endif
endif


if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,/realize,/map else $
  widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map
widget_control,wtext,/input_focus

widget_control,wbase,/show
if n_elements(handler) eq 0 then handler='xinput_event'
xmanager,'xinput',wbase,group=group,modal=modal,event_handler=handler
if (not keyword_set(group)) then xmanager

if n_elements(xtext) ne 0 then text=xtext(n_elements(xtext)-1) else text=''
 
return & end

