;+
; Project     :	SDAC
;
; Name        :	XKILL
;
; Purpose     :	To kill a bunch of X widgets
;
; Explanation :	
;
; Use         :	XKILL,ID1,ID2,..............ID10
;              
; Inputs      :	IDn = widget id to kill
;
; Opt. Inputs : None.
;
; Outputs     :	None.
;
; Opt. Outputs:	None.
;
; Keywords    :	ALL = if set, then destroy all active widgets
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	Up to 10 specific widgets can be killed
;
; Side effects:	None.
;
; Category    :	Useful stuff
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 18 September 1993
;-

pro xkill,id0,id1,id2,id3,id4,id5,id6,id7,id8,id9,all=all

on_error,1
if keyword_set(all) then begin
 widget_control,/reset,/clear_events,bad_id=destroyed
endif else begin
 for i=0,n_params()-1 do begin
  param=strcompress('id'+string(i,'(i2)'),/rem)
  stat=execute('defined = n_elements('+param+')')
  if defined gt 0 then begin
   stat=execute('id = '+param)
   for k=0,n_elements(id)-1 do begin
    if xalive(id(k)) then widget_control,id(k),/destroy,/clear_events,bad_id=destroyed
   endfor
  endif
 endfor
endelse

return & end
