;+
; Project     :	SOHO/CDS
;
; Name        : XLIST
;
; Purpose     : lists structure tags in a list widget.
;
; Use         : XLIST,STRUCT.
;
; Inputs      : STRUCT
;
; Opt. Inputs : None.
;
; Outputs     : INDEX = selected index of structure array
;
; Keywords    : 
;               wbase  = widget id of parent widget (input/output)
;               wlist  = widget id of list widget into which to write (input/output)
;               font   = list widget font (def = 'fixed')
;               title  = title of parent base
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Help
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 12 October 1994
;
; Version     : 1
;-

pro xlist_event,  event                         ;event driver routine

common xlist,selected
on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widget

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)
 if bname eq 'close' then  selected=-1
 xkill,event.top
endif

;-- list widget

if wtype eq 6 then selected=event.index

return & end

;--------------------------------------------------------------------------- 

pro xlist,struct,index,wlist=wlist,font=font,select=select,modal=modal,$
          wbase=wbase,title=title,group=group,just_reg=just_reg,$
          xoff=xoff,yoff=yoff,wlabel=wlabel

common xlist,selected
on_error,1

selected=-1
if not have_widgets() then message,'widgets unavailable'
if  (datatype(struct) ne 'STC') then message,'input must be a structure'

if n_elements(wlist) eq 0 then wlist=0l
wlist=long(wlist)
update=xalive(wbase)
if n_elements(font) eq 0 then font='fixed'

;-- get tag definitions

tags=tag_names(struct)
stc_name=tag_names(struct,/structure_name)
if stc_name eq '' then stc_name='ANONYMOUS'
ntags=n_elements(tags)
nstruct=n_elements(struct)

get_screen,fspace,fxpad,fypad
                                
;-- make widgets


if (not update) then begin
 wbase=widget_base(title='XLIST',/column)

;-- buttons

 if not keyword_set(just_reg) then begin
  row1=widget_base(wbase,/row,space=fspace,xpad=fxpad,ypad=fypad)   
  cfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
  cfont=(get_dfont(cfont))(0)
  closeb=widget_button(row1,value='Close',uvalue='close',/no_release,/frame,font=cfont)
 endif

 if keyword_set(select) then begin
  selb=widget_button(row1,value='Select and Exit',uvalue='select',/no_release,$
                    /frame,font=cfont)
 endif

;-- labels

 row2=widget_base(wbase,/row,space=fspace,xpad=fxpad,ypad=fypad,/frame)   
 wlabel=widget_label(row2,value='',font=font)

;-- lists

 wlist=widget_list(wbase,value='',/frame,ysize=20,font=font)
endif

;-- make string array for list widget

slabel=tags(0)
for k=1,ntags-1 do slabel=slabel+'   '+tags(k)

for j=0,nstruct-1 do begin
 tstruct=struct(j)
 tlabel=slabel
 for i=0,ntags-1 do begin
  temp=tstruct.(i)
  if datatype(temp) eq 'STC' then outsub='STRUCTURE' else $
   outsub=arr2str(temp,delim=' ')
  insub=tags(i)
  tlabel=strep(tlabel,insub,outsub)
 endfor
 if j eq 0 then field=tlabel else field=[field,tlabel]
endfor

;-- write to list widget

widget_control,wlabel,set_value=slabel
widget_control,wlist,set_value=field
if keyword_set(select) then begin
 selected=0 & widget_control,wlist,set_list_select=selected
endif

if not update then begin
 if n_elements(xoff)*n_elements(yoff) eq 0 then $
  widget_control,wbase,/realize else $
   widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff
 xmanager,'xlist',wbase,group=group,just_reg=just_reg,modal=modal
 if (not keyword_set(group)) and (not keyword_set(just_reg)) then xmanager
endif else begin
 if xalive(wbase) then widget_control,wbase,/show,/map
endelse

if keyword_set(select) then index=selected else index=-1


 return & end

