;+
; Project     :	SOHO - CDS
;
; Name        : XOPT
;
; Purpose     : present user with menu of options
;
; Use         : xopt,options
;
; Inputs      : options = array of options (e.g. ['YES', 'NO'])
;
; Opt. Inputs : None.
;
; Outputs     : value = 1 if option selected, 0 otherwise
;
; Opt. Outputs: None.
;
; Keywords    : 
;              instruct = instructions (string)
;              def = def option value
;              font = widget font
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Help
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 12 October 1994
;
; Version     : 1
;-


pro xopt_event,  event                         ;event driver routine

common xopt,val,buttons,wtext
on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)
 chk=where(event.id eq buttons,cnt)
 if cnt gt 0 then val=fix(bname)

 case bname of 
  'CANCEL'   : val=-1 
  'CONTINUE' : begin
    if (val lt 0) then begin
     widget_control,wtext,set_value=['','Please make a choice','before continuing','']
     return
    endif
   end
   else: begin 
    if event.select eq 1 then val=fix(bname) else val=-1
    return 
   end
 endcase
endif

xkill,event.top

return & end

;--------------------------------------------------------------------------- 

pro xopt,options,value,instruct=instruct,group=group,$
 xoff=xoff,yoff=yoff,row=row,def=def,modal=modal,font=font

common xopt,val,buttons,wtext
val=-1


on_error,1

if not have_widgets() then message,'widgets unavailable'
if  (datatype(options) ne 'STR') then message,'input must be a string'

;-- make widgets

wfont=''
if datatype(font) eq 'STR' then wfont=(get_dfont(font))(0)

get_screen,fspace,fxpad,fypad

wbase=widget_base(title='  ',/column,space=fspace,xpad=fxpad,ypad=fypad)

row0=widget_base(wbase,/row,space=20*fspace,xpad=fxpad,ypad=fypad)


temp1=widget_base(row0,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
quit=widget_button(temp1,value='CANCEL',uvalue='CANCEL',font=wfont)
temp2=widget_base(row0,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
ok=widget_button(temp2,value='CONTINUE',uvalue='CONTINUE',font=wfont)

if datatype(instruct) ne 'STR' then comment='' else comment=instruct
comment=[' ',comment,' ']
xsize=max(strlen(comment)) < 50
ysize=n_elements(comment)
row1=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
wtext=widget_text(row1,xsize=xsize,ysize=ysize,value=comment,font=wfont,/scroll)

nval=n_elements(options)
row2=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
xmenu,options,row2,space=fspace,xpad=fxpad,ypad=fypad,$
      buttons=buttons,font=wfont,$
      uvalue=sindgen(nval),row=keyword_set(row),/exclusive,/frame

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 if n_elements(group) ne 0 then begin
  widget_control,wbase,/realize,tlb_get_size=wsize,map=0
  widget_control,group,tlb_get_offset=goff,tlb_get_size=gsize
  xsize=((gsize(0)-wsize(0))/2) > 0.
  ysize=((gsize(1)-wsize(1))/2) > 0.
  xoff=goff(0)+xsize
  yoff=goff(1)+ysize
 endif
endif

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,/realize,/map else $
  widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map

val=-1
if n_elements(def) ne 0 then begin
 chk=where(def eq indgen(nval),cnt)
 if cnt gt 0 then begin
  val=def
  widget_control,buttons(chk(0)),/set_button
 endif
endif

widget_control,wbase,/show 
xmanager,'xopt',wbase,group=group,just_reg=just_reg,modal=modal
if (not keyword_set(group)) and (not keyword_set(just_reg)) then xmanager

value=val
 
return & end

