;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Document name: xsel_list.pro
; Created by:    Liyun Wang, GSFC/ARC, September 20, 1994
;
; Last Modified: Wed Oct 19 11:22:39 1994 (lwang@orpheus.gsfc.nasa.gov)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:	
;       XSEL_LIST()
;
; PURPOSE: 
;       To select one item from a list.
;
; EXPLANATION:
;       
; CALLING SEQUENCE: 
;       Result = XSEL_LIST(options)
;
; INPUTS:
;       OPTIONS -- String array that contains the lists.
;
; OPTIONAL INPUTS: 
;       TITLE=TITLE, Title of the widget. Default: 'XSET_LIST'
;
; OUTPUTS:
;       RESULT -- Selected item (one of elements from the LISTS
;                 array). A null string is returned if no selection is
;                 made.
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS: 
;       INDEX -- Return index of the selected item
;                otherwise return the content of the selected item.
;
; CALLS:
;       POPUP_MSG, FLASH_MSG
;
; COMMON BLOCKS:
;       XSEL_LIST
;
; RESTRICTIONS: 
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;       Utility, widget
;
; PREVIOUS HISTORY:
;       
; MODIFICATION HISTORY:
;       Written September 20, 1994, by Liyun Wang, GSFC/ARC
;       
; VERSION:
;       
;-
;
PRO XSEL_LIST_EVENT, event
   COMMON xsel_list, lists, list, idx
   WIDGET_CONTROL, event.top, get_uvalue = selected
   WIDGET_CONTROL, event.id, get_uvalue = aaa
   CASE (aaa) OF
      'QUIT': BEGIN
         list = ''
         idx = -1
         WIDGET_CONTROL, event.top, /destroy
      END
      'DONE': BEGIN
         WIDGET_CONTROL, selected, get_value = name_str
         list = name_str(0)
         IF list EQ ' ' OR list EQ '' THEN BEGIN
            flash_msg, selected, 'Invalid selection!!', num = 2
            WAIT, 1.0
            WIDGET_CONTROL, selected, set_value = ''
            RETURN
         ENDIF
         WIDGET_CONTROL, event.top, /destroy
      END
      'LIST': BEGIN
         idx = event.index
         list = lists(idx)
         WIDGET_CONTROL, selected, set_value = list
      END
   ENDCASE   
END

FUNCTION XSEL_LIST, options, group=group, index=index, title=title, $
                    subtitle=subtitle
   COMMON xsel_list, lists, list, idx
   ON_ERROR, 2
   IF N_ELEMENTS(options) EQ 0 THEN BEGIN
      popup_msg, ['Message from XSEL_LIST:','No lists provided.'],$
         title = 'Sorry'
      RETURN, -1
   ENDIF
   lists = options
   IF N_ELEMENTS(title) EQ 0 THEN $
      base = WIDGET_BASE(title = 'XSEL_LIST',/column) $
   ELSE $
      base = WIDGET_BASE(title = title,/column) 

   list_bs = WIDGET_BASE(base,/column,/frame, space = 1)
   IF N_ELEMENTS(subtitle) EQ 0 THEN $
      f_title = WIDGET_LABEL(list_bs,value = 'Available Selections') $
   ELSE $
      f_title = WIDGET_LABEL(list_bs,value = subtitle) 
   
   f_list = WIDGET_LIST(list_bs, value = lists, ysize = 10, $
                      uvalue = 'LIST')
   name = ' '
   sel_bs = WIDGET_BASE(base,/row, /frame)
   label = WIDGET_LABEL(sel_bs,value = 'Selection:')
   selected = WIDGET_TEXT(sel_bs, value = ' ', xsize = 20)

   cmd_bs = WIDGET_BASE(base, /row, space = 30, /frame, xpad = 50)
   accept = WIDGET_BUTTON(cmd_bs, value = 'Accept', uvalue = 'DONE')
   quit = WIDGET_BUTTON(cmd_bs, value = 'Cancel', uvalue = 'QUIT')

   WIDGET_CONTROL, base,/realize
   WIDGET_CONTROL, base, set_uvalue = selected
   XMANAGER, 'xsel_list',base,group = group, modal = KEYWORD_SET(group)
   IF KEYWORD_SET(index) THEN RETURN, idx ELSE $
      IF idx GE 0 THEN RETURN, lists(idx) ELSE RETURN, -1
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of 'xsel_list.pro'.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
