;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Document name: xset_color.pro
; Created by:    Liyun Wang, GSFC/ARC, August 18, 1994
;
; Last Modified: Fri Sep 16 16:59:24 1994 (lwang@orpheus.gsfc.nasa.gov)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
PRO XSET_COLOR_EVENT, event
;
; Project     :	SOHO - CDS
;
; Pro Name    :	XSET_COLOR_EVENT
;
; Purpose     : Event handler of XSET_COLOR below
;
; Written     :	Liyun Wang, GSFC/ARC, August 30, 1994
;               Modified from set_value.pro
;
   COMMON xset_color, value_sv

   ON_ERROR, 2

   wtype = WIDGET_INFO(event.id,/type)

;-- Get two widget IDs from the UVALUE of the top widget:
   WIDGET_CONTROL, event.top, get_uvalue = c_value

   WIDGET_CONTROL, event.id, get_uvalue = evt_num, get_value = cur_value
   CASE (evt_num) OF
      0: BEGIN                  ; Accepted
         WIDGET_CONTROL, c_value.sld_id, get_value = value
         IF (value NE  value_sv) THEN $
            value_sv = value
         WIDGET_CONTROL, event.top, /destroy
      END
      1: BEGIN                  ; Reset
         value = value_sv
         WIDGET_CONTROL, c_value.sld_id, set_value = value
         WIDGET_CONTROL, c_value.info_id, set_value = value
         POLYFILL, c_value.dispw_x, c_value.dispw_y, /dev, color = value
      END
      2: BEGIN                  ; Canceled, also restore original value
         value = value_sv
         WIDGET_CONTROL, event.top, /destroy
      END
      3: BEGIN                  ; Value obtained from the slider widget
         WIDGET_CONTROL, c_value.sld_id, get_value = value
         WIDGET_CONTROL, c_value.info_id, set_value = value
         POLYFILL, c_value.dispw_x, c_value.dispw_y, /dev, color = value
      END
      'KEYBOARD': BEGIN         ; Value entered from the keyboard
         WIDGET_CONTROL, c_value.info_id, set_value = cur_value(0)
         WIDGET_CONTROL, c_value.sld_id, set_value = cur_value(0)
         POLYFILL, c_value.dispw_x, c_value.dispw_y, /dev, color = cur_value(0)
      END
      ELSE: RETURN
   ENDCASE
END

PRO XSET_COLOR, color_var, min = min, max = max, $
               title=title, group=group
;+
; Project     :	SOHO - CDS
;
; Name        :	XSET_COLOR
;
; Purpose     : Interactively change a variable associated with color.
;
; Explanation : This routine changes a variable to be used with the
;               COLOR keyword in many routines (e.g., system variables
;               like !p.color, !p.backgroud) through a slider widget
;               interface. The color associated with its index is
;               shown instantly.
;
; Use         : XSET_COLOR, color_var [, min = min, max = max]
;
; Inputs      : color_var -- Short integer for color index
;
; Opt. Inputs : None.
;
; Outputs     : Also the input, but its value may have changed
;
; Opt. Outputs:
;
; Keywords    : MIN   -- Minimum value of the range, default: 0
;               MAX   -- Maximum value of the range, default: !d.n_colors-1
;               TITLE -- Title of the widget; default: "Set Color"
;               GROUP -- Group ID of an upper widget which would be
;                        desensitized if GROUP is set upon calling this
;                        routine 
;
; Calls       : BELL, DATATYPE
;
; Common      : xset_color 
;
; Restrictions: Graphic device has to support widget
;
; Side effects: The input value is modified
;
; Category    : Utilities/Widget
;
; Prev. Hist. :
;
; Written     :	Liyun Wang, GSFC/ARC, August 18, 1994
;
; Modified    : Liyun Wang, GSFC/ARC, August 31, 1994
;                  Modified from set_value.pro
;
; Version     : 1.0
;-
;
   COMMON xset_color, value_sv
   ON_ERROR, 2

   IF N_ELEMENTS(color_var) EQ 0 THEN BEGIN
      PRINT, ' ' &  bell
      PRINT, 'XSET_COLOR -- Usage:'
      PRINT, '     XSET_COLOR, color_var [, min = min] [, max = max]'
      PRINT, ' '
      RETURN
   ENDIF

   dtype = datatype(color_var,2)
   IF (dtype NE 2) AND (dtype NE 3) THEN BEGIN
      PRINT, 'XSET_COLOR -- The input parameter must be of integer type.'
      PRINT, ' '
      RETURN
   ENDIF

   value_sv = color_var < (!d.n_colors-1)

   IF N_ELEMENTS(title) EQ 0 THEN title = 'Set Color'

;-- Create a top base
   base =  WIDGET_BASE (title = title, /column, space = 25)

   row1 = WIDGET_BASE(base, /row)
   temp1 = WIDGET_LABEL(row1,value = ' ')
   button_base = WIDGET_BASE (row1,space = 20, xpad = 30, /row, /frame)
   done        = WIDGET_BUTTON (button_base, value = 'Accept', uvalue = 0)
   resetting   = WIDGET_BUTTON (button_base, value = 'Reset', uvalue = 1)
   cancel      = WIDGET_BUTTON (button_base, value = 'Cancel', uvalue = 2)
   temp1 = WIDGET_LABEL(row1,value = ' ')

   base1  = WIDGET_BASE (base, /column) ; , ysize = 100)
   base2 = WIDGET_BASE(base1,/row, space = 20)

   temp1 = WIDGET_LABEL(base2, value = ' ')
   temp2 = WIDGET_BASE(base2, /frame)
   info_id = cw_field(temp2, title = 'Color Index', value = value, $
                      /row, xsize = 3, /RETURN, uvalue = 'KEYBOARD')
   win_width = 20               ; Width of the display area in pixels

   color_bs = WIDGET_BASE(base2, /row, /frame)
   lable_id = WIDGET_LABEL(color_bs, value = 'Color')
   draw_id = WIDGET_DRAW(color_bs, xsize = win_width, $
                         ysize = win_width, /frame)
   temp1 = WIDGET_LABEL(base2, value = ' ')

   slider_x = 250 & slider_y = 30
   IF (N_ELEMENTS(min) EQ 0) THEN min = 0
   IF (N_ELEMENTS(max) EQ 0) THEN max = !d.n_colors-1
   
   sld_id =  WIDGET_SLIDER (base1, minimum = min, maximum = max, $
                            value = value, /frame, uvalue = 3, $
                            ysize = slider_y, /drag, /suppress)

   WIDGET_CONTROL, base, /realize

   dispw_x = [-10, win_width+20, win_width+20, -10, -10]
   dispw_y = [-10, -10, win_width+20, win_width+20, -10]
   WIDGET_CONTROL, draw_id, get_value = win_id
   WSET, win_id
   POLYFILL, dispw_x, dispw_y, /dev, color = value_sv
   WIDGET_CONTROL, info_id, set_value = value_sv
   WIDGET_CONTROL, sld_id, set_value = value_sv

;-- Make a structure to pass some infos to the event handler:
   c_value = {sld_id:sld_id, info_id:info_id, win_id:win_id, $
             dispw_x:dispw_x, dispw_y:dispw_y}

;-- Pass the structure c_value to the event handler via UVALUE of the top
;   base:
   WIDGET_CONTROL, base, set_uvalue = c_value
   XMANAGER, 'xset_color', base, group_leader = group, $
      modal = KEYWORD_SET(group)
   color_var = value_sv
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; End of 'xset_color.pro'.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
