;+
; Project     :	SDAC
;
; Name        : XTEXT
;
; Purpose     : text display widget
;
; Use         : xtext,array
;
; Inputs      : array = string array to display
;
; Opt. Inputs : None.
;
; Outputs     : String array with help info.
;
; Opt. Outputs: None.
;
; Keywords    : 
;              GROUP = GROUP LEADER OF TEXT WIDGET PARENT
;              FONT  = FONT FOR TEXT WIDGET
;              TITLE = TITLE FOR TEXT WIDGET PARENT
;              SPACE = NUMBER OF LINES TO SPACE TEXT
; Expplanation:
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Help
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 20 August 1994
;
;-

pro xtext_event,  event                         ;event driver routine

on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)

 case bname of 

  'close'   : xkill,event.top

  else:  return
 endcase
endif
return & end

;--------------------------------------------------------------------------- 

pro xtext,array,font=font,title=title,group=group,modal=modal,space=space,$
         just_reg=just_reg,wbase=wbase,scroll=scroll,xoff=xoff,yoff=yoff

on_error,1
common xtext_com,xtext_reg

if not keyword_set(just_reg) then begin
 xkill,xtext_reg & delvarx,xtext_reg
endif

if not have_widgets() then message,'widgets unavailable'
if  (datatype(array) ne 'STR') then message,'input must be a string'

if n_elements(title) ne 0 then wtitle=title else wtitle='XTEXT'

;-- make widgets

wfont=''
if datatype(font) eq 'STR' then wfont=(get_dfont(font))(0)

get_screen,fspace,fxpad,fypad

wbase=widget_base(title=wtitle,/column,space=fspace,xpad=fxpad,ypad=fypad)

if not keyword_set(just_reg) then begin
 row=widget_base(wbase,/row,/frame,space=fspace,xpad=fxpad,ypad=fypad)
 closeb=widget_button(row,value='Close',uvalue='close',/no_release,/frame,font=wfont)
endif else begin
 if n_elements(xtext_reg) eq 0 then xtext_reg=wbase
 clook=where(wbase eq xtext_reg,cnt)
 if cnt eq 0 then xtext_reg=[xtext_reg,wbase]
endelse

if n_elements(space) ne 0 then begin
 buff=replicate(' ',space) & text=[buff,array,buff]
endif else text=array

wtext=widget_text(wbase,/frame,scroll=keyword_set(scroll),xsize=max(strlen(text) < 80),$
                  ysize=n_elements(text) < 50 ,value=text,font=wfont)

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 if n_elements(group) ne 0 then begin
  widget_control,wbase,/realize,tlb_get_size=wsize,map=0,show=0
  widget_control,group,tlb_get_offset=goff,tlb_get_size=gsize
  xsize=((gsize(0)-wsize(0))/2) > 0.
  ysize=((gsize(1)-wsize(1))/2) > 0.
  xoff=(goff(0)+xsize)
  yoff=(goff(1)+ysize)
 endif
endif

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,/realize,/map else $
  widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map


xmanager,'xtext',wbase,group=group,modal=modal,just_reg=just_reg
if (not keyword_set(group)) and (not keyword_set(just_reg)) then xmanager
 
return & end

